﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Get Service Appointment step.
    /// </summary>
    public class GetVodStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                state.VideoOnDemand = context.cvt_vodSet.FirstOrDefault(x => x.Id == state.VideoOnDemandId); 
                if (state.VideoOnDemand == null) throw new Exception(string.Format("Unable to retrieve Video On Demand - {0}", state.VideoOnDemandId));

                if (state.VideoOnDemand.cvt_starttime == null) throw new Exception(string.Format("Video On Demand Start Date is null - {0}", state.VideoOnDemandId));
                if (state.VideoOnDemand.cvt_endtime == null) throw new Exception(string.Format("Video On Demand End Date is null - {0}", state.VideoOnDemandId));

                state.AppointmentStartDate = (DateTime) state.VideoOnDemand.cvt_starttime;
                state.AppointmentEndDate = (DateTime) state.VideoOnDemand.cvt_endtime;
            }
        }
    }
}